/*
 * Decompiled with CFR 0.152.
 */
package com.eurospider.cpm3.launcher;

import com.eurospider.cpm3.launcher.Configuration;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Launcher {
    private static final String LAUNCHER_CLASS_RESOURCE = Launcher.class.getName().replace(".", "/") + ".class";
    private static final String JAR_PREFIX = "jar:";
    private static final String FILE_PREFIX = "file:";
    private static final String DEFAULT_BASE_NAME = "launcher";
    private static final String JAR_EXTENSION = ".jar";
    private static final String CONFIGURATION_EXTENSION = ".cfg";
    private static final String TEMPORARY_EXTENSION = ".tmp";
    private static final String CONTROL_EXTENSION = ".txt";
    private static final String LAST_MODIFIED_FILE_NAME = "lastmodified.txt";
    private static final String CLIENT_FILE_NAME = "client.jar";
    private static final String LOG_FILE_NAME = "log.txt";
    private static final String CONFIGURATION_FILE_ENVIRONMENT_VARIABLE_NAME = "CPM_LAUNCHER_CFG";
    private static final String CLIENT_LAUNCHER_CONTROL_FILE_SYSTEM_PROPERTY_NAME = "cpm.client.launcherControlFile";
    private static final String CLIENT_SERVICE_URL_SYSTEM_PROPERTY_NAME = "cpm.client.serviceUrl";
    private static final String CLIENT_IGNORE_CERTIFICATE_SYSTEM_PROPERTY_NAME = "cpm.client.ignoreCertificate";
    private static final String CLIENT_LOOK_AND_FEEL_SYSTEM_PROPERTY_NAME = "cpm.client.lookAndFeel";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static final SimpleDateFormat LAST_MODIFIED_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    private static final int CONNECTION_TIMEOUT = 10000;
    private static JFrame frame;
    private static BufferedImage logoImage;
    private static Dimension logoImageDimension;
    private static JPanel logoPanel;
    private static JProgressBar progressBar;
    private static JLabel errorTitle;
    private static JTextArea errorMessageTextArea;
    private static JScrollPane errorMessage;
    private static JButton button;
    private static Path dataDirectory;
    private static Path lastModifiedFile;
    private static Path clientFile;
    private static Path temporaryClientFile;
    private static Path logFile;
    private static Path launcherControlFile;
    private static Configuration configuration;
    private static URL clientUrl;
    private static URL serviceUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, IOException, URISyntaxException {
        Launcher.prepare();
        Launcher.show();
        try {
            Date remoteLastModified;
            Optional<String> localLastModifiedString;
            Path configurationFile;
            String configurationFileEnvironmentVariableValue = System.getenv(CONFIGURATION_FILE_ENVIRONMENT_VARIABLE_NAME);
            if (configurationFileEnvironmentVariableValue != null) {
                configurationFile = Path.of(configurationFileEnvironmentVariableValue, new String[0]);
                if (!Files.exists(configurationFile, new LinkOption[0])) {
                    throw new RuntimeException("Missing configuration file [" + configurationFile.toString() + "], location came from environment variable [CPM_LAUNCHER_CFG].");
                }
            } else {
                String baseName;
                Path baseDirectory;
                URI launcherClassUrl = Launcher.class.getClassLoader().getResource(LAUNCHER_CLASS_RESOURCE).toURI();
                if (launcherClassUrl.toString().startsWith("jar:file:")) {
                    URI jarUrl = new URI(launcherClassUrl.toString().substring(JAR_PREFIX.length(), launcherClassUrl.toString().indexOf("!")));
                    Path jarFile = Paths.get(jarUrl);
                    baseDirectory = jarFile.getParent();
                    String jarFileName = jarFile.getFileName().toString();
                    baseName = jarFileName.substring(0, jarFileName.length() - JAR_EXTENSION.length());
                } else if (launcherClassUrl.toString().startsWith(FILE_PREFIX)) {
                    URI baseDirectoryUri = new URI(launcherClassUrl.toString().substring(0, launcherClassUrl.toString().length() - LAUNCHER_CLASS_RESOURCE.length() - 1));
                    baseDirectory = Paths.get(baseDirectoryUri);
                    baseName = DEFAULT_BASE_NAME;
                } else {
                    throw new RuntimeException("Unsupported start method.");
                }
                configurationFile = baseDirectory.resolve(baseName + CONFIGURATION_EXTENSION);
                if (!Files.exists(configurationFile, new LinkOption[0])) {
                    throw new RuntimeException("Missing configuration file [" + configurationFile.toString() + "], location derived from the JAR file.");
                }
            }
            if (!Files.exists(dataDirectory = Launcher.getApplicationDataDirectory(), new LinkOption[0])) {
                Files.createDirectories(dataDirectory, new FileAttribute[0]);
            }
            lastModifiedFile = dataDirectory.resolve(LAST_MODIFIED_FILE_NAME);
            clientFile = dataDirectory.resolve(CLIENT_FILE_NAME);
            temporaryClientFile = dataDirectory.resolve("client.jar.tmp");
            logFile = dataDirectory.resolve(LOG_FILE_NAME);
            launcherControlFile = dataDirectory.resolve(System.currentTimeMillis() + CONTROL_EXTENSION);
            configuration = new Configuration();
            try (BufferedReader reader = Files.newBufferedReader(configurationFile);){
                configuration.load(reader);
            }
            if (configuration.getBaseUrl() == null) {
                throw new RuntimeException("Missing base URL.");
            }
            clientUrl = new URL(configuration.getBaseUrl() + "/client.jar");
            serviceUrl = new URL(configuration.getBaseUrl() + "/service");
            if (configuration.getHttpsProxyHost() != null) {
                System.setProperty(HTTPS_PROXY_HOST, configuration.getHttpsProxyHost());
            }
            if (configuration.getHttpsProxyPort() > 0) {
                System.setProperty(HTTPS_PROXY_PORT, Integer.toString(configuration.getHttpsProxyPort()));
            }
            if (configuration.isDisableSslServerCertificateValidation()) {
                Launcher.disableSslServerCertificateValidation();
            }
            Date localLastModified = null;
            if (Files.exists(lastModifiedFile, new LinkOption[0]) && (localLastModifiedString = Files.lines(lastModifiedFile, StandardCharsets.UTF_8).findFirst()).isPresent()) {
                localLastModified = LAST_MODIFIED_FORMAT.parse(localLastModifiedString.get());
            }
            try {
                HttpURLConnection clientUrlHeadConnection = (HttpURLConnection)clientUrl.openConnection();
                clientUrlHeadConnection.setRequestMethod("HEAD");
                clientUrlHeadConnection.setConnectTimeout(10000);
                clientUrlHeadConnection.setReadTimeout(10000);
                clientUrlHeadConnection.setInstanceFollowRedirects(true);
                int clientUrlHeadResponseCode = clientUrlHeadConnection.getResponseCode();
                try {
                    if (clientUrlHeadResponseCode != 200) {
                        throw new RuntimeException("Cannot check last modified of URL [" + clientUrl.toString() + "], server response is not okay.");
                    }
                    String remoteLastModifiedString = clientUrlHeadConnection.getHeaderField("Last-Modified");
                    if (remoteLastModifiedString == null) {
                        throw new RuntimeException("Cannot check last modified of URL [" + clientUrl.toString() + "], last modified doesn't exist.");
                    }
                    remoteLastModified = LAST_MODIFIED_FORMAT.parse(remoteLastModifiedString);
                }
                finally {
                    clientUrlHeadConnection.disconnect();
                }
            }
            catch (Throwable e) {
                System.err.println("WARN: HEAD request failed");
                remoteLastModified = new Date();
            }
            if (!Files.exists(clientFile, new LinkOption[0]) || localLastModified == null || localLastModified.before(remoteLastModified)) {
                HttpURLConnection clientUrlGetConnection = (HttpURLConnection)clientUrl.openConnection();
                clientUrlGetConnection.setRequestMethod("GET");
                clientUrlGetConnection.setConnectTimeout(10000);
                clientUrlGetConnection.setReadTimeout(10000);
                clientUrlGetConnection.setInstanceFollowRedirects(true);
                int clientUrlGetResponseCode = clientUrlGetConnection.getResponseCode();
                try {
                    if (clientUrlGetResponseCode != 200) {
                        throw new RuntimeException("Cannot get the client from URL [" + clientUrl.toString() + "], server response is not okay.");
                    }
                    String lastModifiedString = clientUrlGetConnection.getHeaderField("Last-Modified");
                    long size = clientUrlGetConnection.getContentLength();
                    long written = 0L;
                    progressBar.setIndeterminate(size < 0L);
                    if (size < 0L) {
                        progressBar.setString("Downloading client: 0 kB");
                    } else {
                        progressBar.setValue(0);
                        progressBar.setString("Downloading client: 0%");
                    }
                    try (InputStream clientInputStream = clientUrlGetConnection.getInputStream();
                         OutputStream clientOutputStream = Files.newOutputStream(temporaryClientFile, new OpenOption[0]);){
                        int read;
                        byte[] buffer = new byte[524288];
                        while ((read = clientInputStream.read(buffer)) != -1) {
                            clientOutputStream.write(buffer, 0, read);
                            written += (long)read;
                            if (size < 0L) {
                                progressBar.setString("Downloading client: " + written / 1000L + " kB");
                                continue;
                            }
                            int progress = (int)(1000.0f / (float)size * (float)written);
                            progressBar.setValue(progress);
                            progressBar.setString("Downloading client: " + progress / 10 + "%");
                        }
                    }
                    progressBar.setIndeterminate(false);
                    progressBar.setValue(1000);
                    progressBar.setString("Downloadig client: done.");
                    Files.move(temporaryClientFile, clientFile, StandardCopyOption.REPLACE_EXISTING);
                    Files.write(lastModifiedFile, (lastModifiedString + "\n").getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                finally {
                    clientUrlGetConnection.disconnect();
                }
            }
            progressBar.setIndeterminate(true);
            progressBar.setString("Starting client ...");
            if (Files.exists(launcherControlFile, new LinkOption[0])) {
                Files.delete(launcherControlFile);
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add("java");
            if (configuration.getJvmOptions() != null) {
                configuration.getJvmOptions().forEach(command::add);
            }
            if (configuration.getHttpsProxyHost() != null) {
                command.add("-Dhttps.proxyHost=" + configuration.getHttpsProxyHost());
            }
            if (configuration.getHttpsProxyPort() > 0) {
                command.add("-Dhttps.proxyPort=" + configuration.getHttpsProxyPort());
            }
            command.add("-Dcpm.client.serviceUrl=" + serviceUrl.toString());
            command.add("-Dcpm.client.launcherControlFile=" + launcherControlFile.toAbsolutePath().toString());
            command.add("-Dcpm.client.ignoreCertificate=" + configuration.isDisableSslServerCertificateValidation());
            if (configuration.getLookAndFeel() != null) {
                command.add("-Dcpm.client.lookAndFeel=" + configuration.getLookAndFeel());
            }
            command.add("-jar");
            command.add(clientFile.toAbsolutePath().toString());
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.directory(dataDirectory.toAbsolutePath().toFile());
            processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(logFile.toFile()));
            processBuilder.redirectErrorStream(true);
            if (configuration.getEnvironmentVariables() != null) {
                processBuilder.environment().putAll(configuration.getEnvironmentVariables());
            }
            processBuilder.start();
            while (!Files.exists(launcherControlFile, new LinkOption[0])) {
                Thread.sleep(100L);
            }
            Files.delete(launcherControlFile);
            System.exit(0);
        }
        catch (Throwable e) {
            Launcher.error(e);
        }
    }

    private static void prepare() throws IOException {
        frame = new JFrame("eCPM Launcher");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), 1));
        frame.setResizable(false);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().setBackground(Color.white);
        frame.setUndecorated(true);
        frame.setIconImage(new ImageIcon(Launcher.class.getResource("icon.png")).getImage());
        logoImage = ImageIO.read(Launcher.class.getResource("image.jpg"));
        logoImageDimension = new Dimension(logoImage.getWidth(), logoImage.getHeight());
        logoPanel = new JPanel(){
            private static final long serialVersionUID = -7072404113595857389L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(logoImage, 0, 0, null);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(logoImageDimension);
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(logoImageDimension);
            }
        };
        logoPanel.setAlignmentX(0.5f);
        frame.getContentPane().add(logoPanel);
        frame.add(Box.createRigidArea(new Dimension(5, 5)));
        progressBar = new JProgressBar(0, 1000);
        progressBar.setStringPainted(true);
        progressBar.setAlignmentX(0.5f);
        frame.getContentPane().add(progressBar);
        errorTitle = new JLabel();
        errorTitle.setText("Error");
        errorTitle.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        errorTitle.setAlignmentX(0.5f);
        errorTitle.setVisible(false);
        frame.getContentPane().add(errorTitle);
        errorMessageTextArea = new JTextArea();
        errorMessageTextArea.setWrapStyleWord(false);
        errorMessageTextArea.setLineWrap(false);
        errorMessageTextArea.setEditable(false);
        errorMessageTextArea.setForeground(Color.RED);
        errorMessage = new JScrollPane(errorMessageTextArea, 20, 30);
        errorMessage.setPreferredSize(new Dimension(Launcher.logoPanel.getPreferredSize().width, 100));
        errorMessage.setBorder(null);
        errorMessage.setAlignmentX(0.5f);
        errorMessage.setVisible(false);
        frame.getContentPane().add(errorMessage);
        frame.add(Box.createRigidArea(new Dimension(5, 5)));
        button = new JButton("Cancel");
        button.addActionListener(e -> System.exit(0));
        button.setAlignmentX(0.5f);
        frame.getContentPane().add(button);
        frame.add(Box.createRigidArea(new Dimension(5, 5)));
    }

    private static void error(Throwable exception) {
        StringWriter errorMessageWriter = new StringWriter();
        if (exception.getMessage() != null) {
            errorMessageWriter.append("Message: ");
            errorMessageWriter.append(exception.getMessage());
            errorMessageWriter.append("\n");
        }
        try (PrintWriter errorMessagePrintWriter = new PrintWriter((Writer)errorMessageWriter, false);){
            exception.printStackTrace(errorMessagePrintWriter);
            errorMessagePrintWriter.close();
        }
        String errorMessageText = errorMessageWriter.toString().replace("\t", " ");
        errorMessageTextArea.setText(errorMessageText);
        button.setText("Quit");
        progressBar.setVisible(false);
        errorTitle.setVisible(true);
        errorMessage.setVisible(true);
        button.addActionListener(e -> System.exit(0));
        Launcher.update();
    }

    private static void show() {
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.toFront();
        frame.requestFocus();
        frame.setVisible(true);
    }

    private static void update() {
        frame.pack();
        frame.repaint();
    }

    private static Path getApplicationDataDirectory() {
        Path path;
        String OS = System.getProperty("os.name").toUpperCase();
        if (OS.contains("WIN")) {
            path = Paths.get(System.getenv("APPDATA"), new String[0]);
        } else if (OS.contains("MAC")) {
            path = Paths.get(System.getProperty("user.home"), "Library");
        } else if (OS.contains("NUX")) {
            path = Paths.get(System.getProperty("user.home"), ".local", "share");
        } else {
            throw new RuntimeException("Unsuppored operating system [OS].");
        }
        return path.resolve("eurospider").resolve("ecpm");
    }

    private static void disableSslServerCertificateValidation() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }}, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        System.err.println("WARN: SSL server certificate validation is disabled");
    }
}

