/*
 * Decompiled with CFR 0.152.
 */
package com.eurospider.cpm3.launcher;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class Configuration {
    private Pattern LINE_PATTERN = Pattern.compile("^\\s*([\\w\\._]+)\\s*[:=]\\s*(.*)\\s*$");
    private Pattern MAP_PATTERN = Pattern.compile("^\\s*([\\w\\._]+)\\s*[:=]\\s*(.*)\\s*$");
    private String baseUrl;
    private String lookAndFeel;
    private boolean disableSslServerCertificateValidation;
    private String httpsProxyHost;
    private int httpsProxyPort;
    private List<String> jvmOptions;
    private Map<String, String> environmentVariables;

    public void load(BufferedReader reader) {
        this.jvmOptions = new ArrayList<String>();
        this.environmentVariables = new HashMap<String, String>();
        try (Stream<String> lines = reader.lines();){
            Matcher lineMatcher = this.LINE_PATTERN.matcher("");
            Matcher mapMatcher = this.MAP_PATTERN.matcher("");
            lines.forEach(l -> this.line(lineMatcher, mapMatcher, (String)l));
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    public boolean isDisableSslServerCertificateValidation() {
        return this.disableSslServerCertificateValidation;
    }

    public void setDisableSslServerCertificateValidation(boolean disableSslServerCertificateValidation) {
        this.disableSslServerCertificateValidation = disableSslServerCertificateValidation;
    }

    public String getHttpsProxyHost() {
        return this.httpsProxyHost;
    }

    public void setHttpsProxyHost(String httpsProxyHost) {
        this.httpsProxyHost = httpsProxyHost;
    }

    public int getHttpsProxyPort() {
        return this.httpsProxyPort;
    }

    public void setHttpsProxyPort(int httpsProxyPort) {
        this.httpsProxyPort = httpsProxyPort;
    }

    public List<String> getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(List<String> jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    private void line(Matcher lineMatcher, Matcher mapMatcher, String line) {
        lineMatcher.reset(line);
        if (lineMatcher.matches()) {
            this.line(mapMatcher, lineMatcher.group(1), lineMatcher.group(2));
        }
    }

    private void line(Matcher mapMatcher, String key, String value) {
        switch (key) {
            case "baseUrl": {
                this.baseUrl = value;
                break;
            }
            case "lookAndFeel": {
                this.lookAndFeel = value;
                break;
            }
            case "disableSslServerCertificateValidation": {
                this.disableSslServerCertificateValidation = Boolean.parseBoolean(value);
                break;
            }
            case "httpsProxyHost": {
                this.httpsProxyHost = value;
                break;
            }
            case "httpsProxyPort": {
                this.httpsProxyPort = Integer.parseInt(value);
                break;
            }
            case "jvmOptions": {
                this.jvmOptions.add(value);
                break;
            }
            case "environmentVariables": {
                mapMatcher.reset(value);
                if (!mapMatcher.matches()) break;
                this.environmentVariables.put(mapMatcher.group(1), mapMatcher.group(2));
            }
        }
    }
}

